
<?php $__env->startSection('title','Data Admin'); ?>
<?php $__env->startSection('page','Data Admin'); ?>

<?php $__env->startSection('content'); ?>

<div class="card shadow-sm border-0">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0 fw-semibold">Data Admin</h5>

        <!-- BUTTON TAMBAH -->
        <button class="btn btn-primary btn-sm"
                data-bs-toggle="modal"
                data-bs-target="#modalTambah"
                data-bs-toggle="tooltip"
                title="Tambah Admin">
            <i class="bi bi-plus-circle"></i>
        </button>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-light text-center">
                    <tr>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>No. Telp</th>
                        <th>Alamat</th>
                        <th>Jam Masuk</th>
                        <th>Jam Keluar</th>
                        <th width="140">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $admin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($a->name); ?></td>
                        <td><?php echo e($a->email); ?></td>
                        <td><?php echo e($a->phone); ?></td>
                        <td><?php echo e($a->alamat); ?></td>
                        <td><?php echo e($a->jam_masuk ?? '-'); ?></td>
                        <td><?php echo e($a->jam_keluar ?? '-'); ?></td>
                        <td class="text-center">

                            <!-- DETAIL -->
                            <button class="btn btn-info btn-sm text-white"
                                data-bs-toggle="modal"
                                data-bs-target="#modalDetail<?php echo e($a->id); ?>"
                                title="Detail">
                                <i class="bi bi-eye-fill"></i>
                            </button>

                            <!-- EDIT -->
                            <button class="btn btn-warning btn-sm text-white"
                                data-bs-toggle="modal"
                                data-bs-target="#modalEdit<?php echo e($a->id); ?>"
                                title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </button>

                            <!-- HAPUS -->
                            <button class="btn btn-danger btn-sm"
                                data-bs-toggle="modal"
                                data-bs-target="#modalHapus<?php echo e($a->id); ?>"
                                title="Hapus">
                                <i class="bi bi-trash-fill"></i>
                            </button>

                        </td>
                    </tr>

                    <!-- ================= DETAIL MODAL ================= -->
                    <div class="modal fade" id="modalDetail<?php echo e($a->id); ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Detail Admin</h5>
                                    <button class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <p><strong>Nama:</strong> <?php echo e($a->name); ?></p>
                                    <p><strong>Email:</strong> <?php echo e($a->email); ?></p>
                                    <p><strong>No. Telp:</strong> <?php echo e($a->phone); ?></p>
                                    <p><strong>Alamat:</strong> <?php echo e($a->alamat); ?></p>
                                    <p><strong>Jam Masuk:</strong> <?php echo e($a->jam_masuk); ?></p>
                                    <p><strong>Jam Keluar:</strong> <?php echo e($a->jam_keluar); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ================= EDIT MODAL ================= -->
                    <div class="modal fade" id="modalEdit<?php echo e($a->id); ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <form action="<?php echo e(route('admin.update',$a->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Edit Admin</h5>
                                        <button class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">
                                        <input type="text" name="name" value="<?php echo e($a->name); ?>" class="form-control mb-2" placeholder="Nama">
                                        <input type="email" name="email" value="<?php echo e($a->email); ?>" class="form-control mb-2" placeholder="Email">
                                        <input type="text" name="phone" value="<?php echo e($a->phone); ?>" class="form-control mb-2" placeholder="No. Telp">
                                        <input type="text" name="alamat" value="<?php echo e($a->alamat); ?>" class="form-control mb-2" placeholder="Alamat">
                                        <input type="time" name="jam_masuk" value="<?php echo e($a->jam_masuk); ?>" class="form-control mb-2">
                                        <input type="time" name="jam_keluar" value="<?php echo e($a->jam_keluar); ?>" class="form-control">
                                    </div>

                                    <div class="modal-footer">
                                        <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                        <button class="btn btn-warning">Update</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- ================= HAPUS MODAL ================= -->
                    <div class="modal fade" id="modalHapus<?php echo e($a->id); ?>" tabindex="-1">
                        <div class="modal-dialog modal-sm">
                            <form action="<?php echo e(route('admin.destroy',$a->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>

                                <div class="modal-content">
                                    <div class="modal-body text-center">
                                        <p>Yakin ingin menghapus?</p>
                                        <button class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Batal</button>
                                        <button class="btn btn-danger btn-sm">Hapus</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- ================= TAMBAH MODAL ================= -->
<div class="modal fade" id="modalTambah" tabindex="-1">
    <div class="modal-dialog">
        <form action="<?php echo e(route('admin.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Admin</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="text" name="name" class="form-control mb-2" placeholder="Nama" required>
                    <input type="email" name="email" class="form-control mb-2" placeholder="Email" required>
                    <input type="text" name="phone" class="form-control mb-2" placeholder="No. Telp" required>
                    <input type="text" name="alamat" class="form-control" placeholder="Alamat" required>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button class="btn btn-primary">Simpan</button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dinda\tamim-malsaly\resources\views/admin/index.blade.php ENDPATH**/ ?>