<?php $__env->startSection('title','Dashboard'); ?>
<?php $__env->startSection('page','Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<div class="container-fluid py-3">

    
    <div class="row g-3">

        <div class="col-md-3">
            <div class="card border-0 shadow-sm p-3 h-100" style="background: linear-gradient(135deg,#312e81,#4f46e5); color:white;">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <small class="opacity-75">Admin</small>
                        <h4 class="fw-bold mt-1 mb-0"><?php echo e($totalAdmin); ?></h4>
                    </div>
                    <i class="bi bi-people fs-3 opacity-50"></i>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm p-3 h-100" style="background: linear-gradient(135deg,#0f766e,#14b8a6); color:white;">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <small class="opacity-75">Barang</small>
                        <h4 class="fw-bold mt-1 mb-0"><?php echo e($totalBarang); ?></h4>
                    </div>
                    <i class="bi bi-box-seam fs-3 opacity-50"></i>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm p-3 h-100" style="background: linear-gradient(135deg,#1e3a8a,#3b82f6); color:white;">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <small class="opacity-75">Pelanggan</small>
                        <h4 class="fw-bold mt-1 mb-0"><?php echo e($totalPelanggan); ?></h4>
                    </div>
                    <i class="bi bi-person-lines-fill fs-3 opacity-50"></i>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm p-3 h-100" style="background: linear-gradient(135deg,#065f46,#10b981); color:white;">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <small class="opacity-75">Transaksi</small>
                        <h4 class="fw-bold mt-1 mb-0"><?php echo e($totalTransaksi); ?></h4>
                    </div>
                    <i class="bi bi-receipt fs-3 opacity-50"></i>
                </div>
            </div>
        </div>

    </div>


    
    <div class="row mt-3 g-3">

        <div class="col-md-6">
            <div class="card border-0 shadow-sm p-3 h-100" style="background-color:#1f2937; color:#e5e7eb;">
                <h6 class="fw-semibold mb-3">Favorit Pelanggan</h6>
                <ul class="list-group list-group-flush">
                    <?php $__currentLoopData = $frequentItemsPelangganA; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center border-0 px-0 py-1" style="background:none; color:#d1d5db;">
                            <?php echo e($item->nama_barang); ?>

                            <span class="badge rounded-pill" style="background:#3b82f6;">
                                <?php echo e($item->jumlah); ?>x
                            </span>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm p-3 h-100" style="background-color:#1f2937; color:#e5e7eb;">
                <h6 class="fw-semibold mb-3">Top Lokasi</h6>
                <table class="table align-middle text-light mb-0">
                    <thead style="color:#9ca3af;">
                        <tr>
                            <th>Lokasi</th>
                            <th>Barang</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $popularItemsByLocation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr style="border-color:#374151;">
                            <td><?php echo e($location->nama_lokasi); ?></td>
                            <td><?php echo e($location->nama_barang); ?></td>
                            <td>
                                <span class="badge rounded-pill" style="background:#10b981;">
                                    <?php echo e($location->jumlah); ?>

                                </span>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>


    
    <div class="row mt-3">
        <div class="col-md-12">
            <div class="card border-0 shadow-sm p-3" style="background-color:#111827; color:#e5e7eb;">
                <h6 class="fw-semibold mb-3">Rekomendasi Promo</h6>
                <div class="row g-3">
                    <?php $__currentLoopData = $promoRecommendations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $promo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="p-3 rounded-3" style="background: linear-gradient(135deg,#6d28d9,#8b5cf6); color:white;">
                                <strong><?php echo e($promo->nama_pelanggan); ?></strong>
                                <div class="small opacity-75 mt-1">
                                    <?php echo e($promo->promo); ?>

                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>


    
    <div class="row mt-3 g-3">

        <div class="col-md-6">
            <div class="card border-0 shadow-sm p-3" style="background-color:#1f2937; color:#e5e7eb;">
                <h6 class="fw-semibold mb-3">Transaksi Bulanan</h6>
                <canvas id="chartBulanan" height="120"></canvas>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm p-3" style="background-color:#1f2937; color:#e5e7eb;">
                <h6 class="fw-semibold mb-3">Transaksi Tahunan</h6>
                <canvas id="chartTahunan" height="120"></canvas>
            </div>
        </div>

    </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener("DOMContentLoaded", function () {

    // ================= BULAN =================
    const namaBulan = [
        'Januari','Februari','Maret','April','Mei','Juni',
        'Juli','Agustus','September','Oktober','November','Desember'
    ];

    const ctxBulan = document.getElementById('chartBulanan');
    if (ctxBulan) {

        let dataBulan = <?php echo json_encode($bulanData ?? []); ?>;

        // paksa selalu 12 data
        dataBulan = Array.from({length: 12}, (_, i) => dataBulan[i] ?? 0);

        new Chart(ctxBulan, {
            type: 'line',
            data: {
                labels: namaBulan,
                datasets: [{
                    data: dataBulan,
                    showLine: false,
                    pointRadius: 6,
                    pointBackgroundColor: '#0d6efd'
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { display: false }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: { display: false },
                        grid: { display: false }
                    }
                }
            }
        });
    }


    // ================= TAHUN =================
    const ctxTahun = document.getElementById('chartTahunan');
    if (ctxTahun) {

        let dataTahun = <?php echo json_encode($tahunData ?? []); ?>;

        dataTahun = [
            dataTahun[0] ?? 0,
            dataTahun[1] ?? 0,
            dataTahun[2] ?? 0
        ];

        new Chart(ctxTahun, {
            type: 'line',
            data: {
                labels: ['2025','2026','2027'],
                datasets: [{
                    data: dataTahun,
                    showLine: false,
                    pointRadius: 8,
                    pointBackgroundColor: '#198754'
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { display: false }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: { display: false },
                        grid: { display: false }
                    }
                }
            }
        });
    }

});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dinda\tamim-malsaly\resources\views/dashboard.blade.php ENDPATH**/ ?>