
<?php $__env->startSection('title','Data Pelanggan'); ?>
<?php $__env->startSection('page','Data Pelanggan'); ?>

<?php $__env->startSection('content'); ?>

<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>No HP</th>
                        <th>Alamat</th>
                        <th>Barang Dibeli</th>
                        <th>Total Transaksi</th>
                        <th width="120" class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $pelanggan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($p->name); ?></td>
                        <td><?php echo e($p->email); ?></td>
                        <td><?php echo e($p->phone); ?></td>
                        <td><?php echo e($p->alamat); ?></td>

                        <td>
                            <?php $__empty_1 = true; $__currentLoopData = $p->transaksis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div>
                                    • <?php echo e($t->nama_barang); ?> (<?php echo e($t->jumlah); ?>)
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <span class="text-muted">Belum ada transaksi</span>
                            <?php endif; ?>
                        </td>

                        <td>
                            <strong>
                                Rp <?php echo e(number_format($p->transaksis->sum('total'),0,',','.')); ?>

                            </strong>
                        </td>

                        <td class="text-center">

                            
                            <button class="btn btn-sm btn-info text-white"
                                    data-bs-toggle="modal"
                                    data-bs-target="#lihatModal<?php echo e($p->id); ?>">
                                <i class="bi bi-eye"></i>
                            </button>

                            
                            <button class="btn btn-sm btn-warning"
                                    data-bs-toggle="modal"
                                    data-bs-target="#editModal<?php echo e($p->id); ?>">
                                <i class="bi bi-pencil-square"></i>
                            </button>

                            
                            <button class="btn btn-sm btn-danger"
                                    data-bs-toggle="modal"
                                    data-bs-target="#hapusModal<?php echo e($p->id); ?>">
                                <i class="bi bi-trash"></i>
                            </button>

                        </td>
                    </tr>

                    
                    <div class="modal fade" id="lihatModal<?php echo e($p->id); ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header bg-info text-white">
                                    <h5 class="modal-title">Detail Pelanggan</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <p><strong>Nama:</strong> <?php echo e($p->name); ?></p>
                                    <p><strong>Email:</strong> <?php echo e($p->email); ?></p>
                                    <p><strong>No HP:</strong> <?php echo e($p->phone); ?></p>
                                    <p><strong>Alamat:</strong> <?php echo e($p->alamat); ?></p>
                                    <hr>
                                    <strong>Riwayat Belanja:</strong>
                                    <?php $__currentLoopData = $p->transaksis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div>
                                            <?php echo e($t->nama_barang); ?> - Rp <?php echo e(number_format($t->total,0,',','.')); ?>

                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="modal fade" id="editModal<?php echo e($p->id); ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <form action="<?php echo e(route('pelanggan.update',$p->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="modal-header bg-warning">
                                        <h5 class="modal-title">Edit Pelanggan</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">
                                        <div class="mb-2">
                                            <label>Nama</label>
                                            <input type="text" name="name" class="form-control" value="<?php echo e($p->name); ?>">
                                        </div>

                                        <div class="mb-2">
                                            <label>Email</label>
                                            <input type="email" name="email" class="form-control" value="<?php echo e($p->email); ?>">
                                        </div>

                                        <div class="mb-2">
                                            <label>No HP</label>
                                            <input type="text" name="phone" class="form-control" value="<?php echo e($p->phone); ?>">
                                        </div>

                                        <div class="mb-2">
                                            <label>Alamat</label>
                                            <textarea name="alamat" class="form-control"><?php echo e($p->alamat); ?></textarea>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button class="btn btn-warning">Update</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    
                    <div class="modal fade" id="hapusModal<?php echo e($p->id); ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header bg-danger text-white">
                                    <h5 class="modal-title">Konfirmasi Hapus</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    Yakin ingin menghapus <strong><?php echo e($p->name); ?></strong>?
                                </div>
                                <div class="modal-footer">
                                    <form action="<?php echo e(route('pelanggan.destroy',$p->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-danger">Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dinda\tamim-malsaly\resources\views/pelanggan/index.blade.php ENDPATH**/ ?>