
<?php $__env->startSection('title','Data Transaksi'); ?>
<?php $__env->startSection('page','Data Transaksi'); ?>

<?php $__env->startSection('content'); ?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light text-center">
                    <tr>
                        <th width="50">No</th>
                        <th>Pelanggan</th>
                        <th>Beli Apa</th>
                        <th>Jumlah</th>
                        <th>Harga Satuan</th>
                        <th>Subtotal</th>
                        <th>Diskon</th>
                        <th>Total Bayar</th>
                        <th>Admin</th>
                        <th>Alamat</th>
                        <th width="170">Aksi</th>
                    </tr>
                </thead>
                <tbody>

                    <?php $__empty_1 = true; $__currentLoopData = $transaksi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $subtotal = $t->jumlah * $t->harga;
                        $diskonNominal = ($subtotal * ($t->diskon ?? 0)) / 100;
                    ?>

                    <tr>
                        <td class="text-center"><?php echo e($loop->iteration); ?></td>

                        <td><?php echo e($t->pelanggan->name ?? '-'); ?></td>

                        <td><?php echo e($t->nama_barang ?? '-'); ?></td>

                        <td class="text-center"><?php echo e($t->jumlah); ?></td>

                        <td>
                            Rp <?php echo e(number_format($t->harga,0,',','.')); ?>

                        </td>

                        <td>
                            Rp <?php echo e(number_format($subtotal,0,',','.')); ?>

                        </td>

                        <td class="text-center">
                            <?php if($t->diskon && $t->diskon > 0): ?>
                                <?php echo e($t->diskon); ?>% <br>
                                <small class="text-danger">
                                    (- Rp <?php echo e(number_format($diskonNominal,0,',','.')); ?>)
                                </small>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>

                        <td>
                            <strong>
                                Rp <?php echo e(number_format($t->total,0,',','.')); ?>

                            </strong>
                        </td>

                        <td><?php echo e($t->admin->name ?? '-'); ?></td>

                        <td><?php echo e($t->alamat ?? '-'); ?></td>

                        <td class="text-center">

                            
                            <a href="<?php echo e(route('transaksi.show',$t->id)); ?>" 
                               class="btn btn-sm btn-info text-white">
                                <i class="bi bi-eye"></i>
                            </a>

                            
                            <a href="<?php echo e(route('transaksi.edit',$t->id)); ?>" 
                               class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil-square"></i>
                            </a>

                            
                            <form action="<?php echo e(route('transaksi.destroy',$t->id)); ?>" 
                                  method="POST" 
                                  class="d-inline"
                                  onsubmit="return confirm('Yakin hapus transaksi ini?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>

                            
                            <a href="<?php echo e(route('transaksi.cetak',$t->id)); ?>" 
                               target="_blank"
                               class="btn btn-sm btn-secondary">
                                <i class="bi bi-printer"></i>
                            </a>

                        </td>
                    </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="11" class="text-center text-muted">
                            Data transaksi belum tersedia
                        </td>
                    </tr>
                    <?php endif; ?>

                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dinda\tamim-malsaly\resources\views/transaksi/index.blade.php ENDPATH**/ ?>