@extends('layouts.app')

@section('title','CRM - Toko Bangunan Tamim Malsaly')

@php
    $hideSidebar = true;
@endphp

@section('content')

<style>

/* GLOBAL */
body {
    background-color: #001233;
    font-family: 'Segoe UI', sans-serif;
    margin: 0;
    overflow-x: hidden;
}

/* HERO */
.hero {
    position: relative;
    background: url("{{ asset('images/spanduk.jpeg') }}") top center/cover no-repeat;
    height: 400px;
}

.hero::before {
    content: "";
    position: absolute;
    inset: 0;
    background: rgba(253, 246, 236, 0.55);
}

/* CONTENT */
.content-wrapper {
    padding: 25px 0 20px 0;
}

.card-custom {
    border-radius: 22px;
    box-shadow: 0 20px 50px rgba(0,0,0,0.08);
    padding: 22px 35px;
    background: linear-gradient(145deg, #f8f1e7, #fffaf3);
    border: 1px solid #eee2d3;
    max-width: 750px;
    margin: auto;
}

.card-custom h4 {
    color: #0d6efd;
    font-weight: 700;
}

.card-custom p {
    color: #5c5c5c;
    margin-bottom: 25px;
}

.btn-login {
    background-color: #0d6efd;
    color: #fff;
    border-radius: 50px;
    padding: 10px 30px;
    border: none;
}

.btn-register {
    background-color: #dc3545;
    color: #fff;
    border-radius: 50px;
    padding: 10px 30px;
    border: none;
}

</style>

<section class="hero"></section>

<section class="content-wrapper container">
    <div class="card-custom text-center">

        <h4 class="mb-3">
            CUSTOMER RELATIONSHIP MANAGEMENT
        </h4>

        <p>
            Untuk Menunjang Penerapan Market Basket Analysis<br>
            Studi Kasus Toko Bangunan Tamim Malsaly
        </p>

        <div class="d-flex justify-content-center gap-3 flex-wrap">
            <a href="{{ route('login') }}" class="btn btn-login">
                Login
            </a>

            <a href="{{ route('register') }}" class="btn btn-register">
                Register
            </a>
        </div>

    </div>
</section>

@endsection