@extends('layouts.app')
@section('title','Data Transaksi')
@section('page','Data Transaksi')

@section('content')

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light text-center">
                    <tr>
                        <th width="50">No</th>
                        <th>Pelanggan</th>
                        <th>Beli Apa</th>
                        <th>Jumlah</th>
                        <th>Harga Satuan</th>
                        <th>Subtotal</th>
                        <th>Diskon</th>
                        <th>Total Bayar</th>
                        <th>Admin</th>
                        <th>Alamat</th>
                        <th width="170">Aksi</th>
                    </tr>
                </thead>
                <tbody>

                    @forelse($transaksi as $t)
                    @php
                        $subtotal = $t->jumlah * $t->harga;
                        $diskonNominal = ($subtotal * ($t->diskon ?? 0)) / 100;
                    @endphp

                    <tr>
                        <td class="text-center">{{ $loop->iteration }}</td>

                        <td>{{ $t->pelanggan->name ?? '-' }}</td>

                        <td>{{ $t->nama_barang ?? '-' }}</td>

                        <td class="text-center">{{ $t->jumlah }}</td>

                        <td>
                            Rp {{ number_format($t->harga,0,',','.') }}
                        </td>

                        <td>
                            Rp {{ number_format($subtotal,0,',','.') }}
                        </td>

                        <td class="text-center">
                            @if($t->diskon && $t->diskon > 0)
                                {{ $t->diskon }}% <br>
                                <small class="text-danger">
                                    (- Rp {{ number_format($diskonNominal,0,',','.') }})
                                </small>
                            @else
                                -
                            @endif
                        </td>

                        <td>
                            <strong>
                                Rp {{ number_format($t->total,0,',','.') }}
                            </strong>
                        </td>

                        <td>{{ $t->admin->name ?? '-' }}</td>

                        <td>{{ $t->alamat ?? '-' }}</td>

                        <td class="text-center">

                            {{-- LIHAT --}}
                            <a href="{{ route('transaksi.show',$t->id) }}" 
                               class="btn btn-sm btn-info text-white">
                                <i class="bi bi-eye"></i>
                            </a>

                            {{-- EDIT --}}
                            <a href="{{ route('transaksi.edit',$t->id) }}" 
                               class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil-square"></i>
                            </a>

                            {{-- HAPUS --}}
                            <form action="{{ route('transaksi.destroy',$t->id) }}" 
                                  method="POST" 
                                  class="d-inline"
                                  onsubmit="return confirm('Yakin hapus transaksi ini?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>

                            {{-- CETAK --}}
                            <a href="{{ route('transaksi.cetak',$t->id) }}" 
                               target="_blank"
                               class="btn btn-sm btn-secondary">
                                <i class="bi bi-printer"></i>
                            </a>

                        </td>
                    </tr>

                    @empty
                    <tr>
                        <td colspan="11" class="text-center text-muted">
                            Data transaksi belum tersedia
                        </td>
                    </tr>
                    @endforelse

                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection