<style>
    .sidebar {
        width:230px;
        height:100vh;
        position:fixed;
        top:0;
        left:0;
        background:#0b1f3a;
        padding:20px 0;
        display:flex;
        flex-direction:column;
    }

    .sidebar-brand {
        text-align:center;
        margin-bottom:20px;
    }

    .logo-wrapper {
        background:#ffffff;
        display:inline-block;
        padding:8px;
        border-radius:12px;
        box-shadow:0 4px 15px rgba(0,0,0,0.25);
        margin-bottom:10px;
    }

    .logo-wrapper img {
        width:45px;
    }

    .sidebar-title {
        color:#ffffff;
        font-size:15px;
        font-weight:600;
        letter-spacing:0.5px;
    }

    .sidebar-subtitle {
        display:block;
        font-size:12px;
        font-weight:400;
        opacity:0.8;
    }

    .sidebar-menu {
        flex:1;
        display:flex;
        flex-direction:column;
        justify-content:space-between;
        padding:0 10px;
    }

    .menu-top,
    .sidebar-bottom {
        display:flex;
        flex-direction:column;
        gap:5px;
    }

    .sidebar-bottom {
        padding-top:15px;
        border-top:1px solid rgba(255,255,255,0.15);
    }

    .sidebar a,
    .sidebar-link {
        display:block;
        width:100%;
        color:#fff;
        padding:12px 20px;
        text-decoration:none;
        border:none;
        background:none;
        text-align:left;
        border-radius:8px;
        transition:0.2s;
        font-size:14px;
    }

    .sidebar a:hover {
        background:#0d6efd;
    }

    .sidebar-link:hover {
        background:#dc3545;
    }

    .content {
        margin-left:230px;
        padding:0;
        min-height:100vh;
    }
</style>

<div class="sidebar">
    <div class="sidebar-brand">
        <div class="logo-wrapper">
            <img src="{{ asset('images/loggo.png') }}" alt="Logo">
        </div>
        <div class="sidebar-title">
            CRM Toko Bangunan
            <span class="sidebar-subtitle">Tamim Malsaly</span>
        </div>
    </div>

    <div class="sidebar-menu">

        <div class="menu-top">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-speedometer2 me-2"></i> Dashboard
            </a>

            <a href="{{ route('admin.index') }}">
                <i class="bi bi-people me-2"></i> Admin
            </a>

            <a href="{{ route('barang.index') }}">
                <i class="bi bi-box-seam me-2"></i> Barang
            </a>

            <a href="{{ route('transaksi.index') }}">
                <i class="bi bi-receipt me-2"></i> Transaksi
            </a>

            <a href="{{ route('pelanggan.index') }}">
                <i class="bi bi-person-lines-fill me-2"></i> Pelanggan
            </a>
        </div>

        <div class="sidebar-bottom">
            <a href="{{ route('profile.edit') }}">
                <i class="bi bi-person-circle me-2"></i> Profile
            </a>

            <button type="button"
                    class="sidebar-link"
                    data-bs-toggle="modal"
                    data-bs-target="#logoutModal">
                <i class="bi bi-box-arrow-right me-2"></i> Logout
            </button>
        </div>

    </div>
</div>