@extends('layouts.app')

@section('title','Profile')
@section('page','Profile')

@section('content')

<style>
    .profile-wrapper {
        max-width: 1100px;
        margin: auto;
    }

    .profile-card {
        border: none;
        border-radius: 18px;
        background: #ffffff;
        box-shadow: 0 8px 30px rgba(0,0,0,0.05);
        transition: all 0.25s ease;
        padding: 35px;
    }

    .profile-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 12px 35px rgba(0,0,0,0.08);
    }

    .profile-card .card-header {
        background: transparent;
        border-bottom: 1px solid #f1f1f1;
        padding-bottom: 15px;
        margin-bottom: 30px;
    }

    .profile-card h5 {
        font-weight: 700;
        font-size: 18px;
        margin-bottom: 0;
    }

    /* ================= GLOBAL BUTTON BASE ================= */

    .profile-wrapper button {
        font-weight: 700 !important;
        border-radius: 10px !important;
        padding: 10px 28px !important;
        margin-top: 25px !important;
        transition: 0.2s ease-in-out !important;
    }

    /* ================= SAVE BUTTON (BLUE) ================= */

    .profile-wrapper .profile-card:not(.danger-zone) button {
        background: linear-gradient(135deg, #5dade2, #3498db) !important;
        color: #ffffff !important;
        border: none !important;
        box-shadow: 0 4px 12px rgba(52,152,219,0.3) !important;
    }

    .profile-wrapper .profile-card:not(.danger-zone) button:hover {
        background: linear-gradient(135deg, #3498db, #2e86c1) !important;
        box-shadow: 0 6px 18px rgba(52,152,219,0.4) !important;
        transform: translateY(-2px);
    }

    /* ================= DELETE BUTTON (FORCE RED) ================= */

    .profile-wrapper .danger-zone button,
    .profile-wrapper .danger-zone button.bg-white,
    .profile-wrapper .danger-zone button[class*="bg-"] {
        background: linear-gradient(135deg, #ff6b6b, #e74c3c) !important;
        color: #ffffff !important;
        border: none !important;
        box-shadow: 0 4px 12px rgba(231,76,60,0.35) !important;
    }

    .profile-wrapper .danger-zone button:hover {
        background: linear-gradient(135deg, #e74c3c, #c0392b) !important;
        box-shadow: 0 6px 18px rgba(231,76,60,0.45) !important;
        transform: translateY(-2px);
    }

    /* ================= CENTER BUTTON WRAPPER ================= */

    .profile-wrapper form .flex.items-center,
    .profile-wrapper form .mt-4,
    .profile-wrapper form .mt-6,
    .profile-wrapper form > div:last-child {
        display: flex !important;
        justify-content: center !important;
        align-items: center;
        width: 100%;
        margin-top: 25px !important;
    }

    /* ================= INPUT STYLE ================= */

    .profile-wrapper input {
        border-radius: 10px !important;
        border: 1px solid #e5e7eb !important;
        padding: 10px 14px !important;
        transition: 0.2s ease;
    }

    .profile-wrapper input:focus {
        border-color: #3498db !important;
        box-shadow: 0 0 0 3px rgba(52,152,219,0.15) !important;
    }

    /* ================= DANGER ZONE ================= */

    .danger-zone {
        border: 1px solid #ffe5e5;
        background: #fff8f8;
    }

    .danger-zone h5 {
        color: #e74c3c;
    }

</style>

<div class="container-fluid profile-wrapper py-4">

    <div class="row g-4">

        <!-- Informasi Profil -->
        <div class="col-lg-6">
            <div class="card profile-card h-100">
                
                <div class="card-header d-flex align-items-center gap-2">
                    <i class="bi bi-person-circle text-primary"></i>
                    <h5>Informasi Profil</h5>
                </div>

                @include('profile.partials.update-profile-information-form')

            </div>
        </div>

        <!-- Ubah Password -->
        <div class="col-lg-6">
            <div class="card profile-card h-100">
                
                <div class="card-header d-flex align-items-center gap-2">
                    <i class="bi bi-shield-lock text-success"></i>
                    <h5>Ubah Password</h5>
                </div>

                @include('profile.partials.update-password-form')

            </div>
        </div>

    </div>

    <!-- Delete Account -->
    <div class="row g-4 mt-3">
        <div class="col-lg-6">
            <div class="card profile-card danger-zone h-100">
                
                <div class="card-header d-flex align-items-center gap-2">
                    <i class="bi bi-exclamation-triangle text-danger"></i>
                    <h5>Hapus Akun</h5>
                </div>

                @include('profile.partials.delete-user-form')

            </div>
        </div>
    </div>

</div>

@endsection