@extends('layouts.app')
@section('title','Data Pelanggan')
@section('page','Data Pelanggan')

@section('content')

<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>No HP</th>
                        <th>Alamat</th>
                        <th>Barang Dibeli</th>
                        <th>Total Transaksi</th>
                        <th width="120" class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($pelanggan as $p)
                    <tr>
                        <td>{{ $p->name }}</td>
                        <td>{{ $p->email }}</td>
                        <td>{{ $p->phone }}</td>
                        <td>{{ $p->alamat }}</td>

                        <td>
                            @forelse($p->transaksis as $t)
                                <div>
                                    • {{ $t->nama_barang }} ({{ $t->jumlah }})
                                </div>
                            @empty
                                <span class="text-muted">Belum ada transaksi</span>
                            @endforelse
                        </td>

                        <td>
                            <strong>
                                Rp {{ number_format($p->transaksis->sum('total'),0,',','.') }}
                            </strong>
                        </td>

                        <td class="text-center">

                            {{-- BUTTON LIHAT --}}
                            <button class="btn btn-sm btn-info text-white"
                                    data-bs-toggle="modal"
                                    data-bs-target="#lihatModal{{ $p->id }}">
                                <i class="bi bi-eye"></i>
                            </button>

                            {{-- BUTTON EDIT --}}
                            <button class="btn btn-sm btn-warning"
                                    data-bs-toggle="modal"
                                    data-bs-target="#editModal{{ $p->id }}">
                                <i class="bi bi-pencil-square"></i>
                            </button>

                            {{-- BUTTON HAPUS --}}
                            <button class="btn btn-sm btn-danger"
                                    data-bs-toggle="modal"
                                    data-bs-target="#hapusModal{{ $p->id }}">
                                <i class="bi bi-trash"></i>
                            </button>

                        </td>
                    </tr>

                    {{-- ================= MODAL LIHAT ================= --}}
                    <div class="modal fade" id="lihatModal{{ $p->id }}" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header bg-info text-white">
                                    <h5 class="modal-title">Detail Pelanggan</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <p><strong>Nama:</strong> {{ $p->name }}</p>
                                    <p><strong>Email:</strong> {{ $p->email }}</p>
                                    <p><strong>No HP:</strong> {{ $p->phone }}</p>
                                    <p><strong>Alamat:</strong> {{ $p->alamat }}</p>
                                    <hr>
                                    <strong>Riwayat Belanja:</strong>
                                    @foreach($p->transaksis as $t)
                                        <div>
                                            {{ $t->nama_barang }} - Rp {{ number_format($t->total,0,',','.') }}
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- ================= MODAL EDIT ================= --}}
                    <div class="modal fade" id="editModal{{ $p->id }}" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <form action="{{ route('pelanggan.update',$p->id) }}" method="POST">
                                    @csrf
                                    @method('PUT')

                                    <div class="modal-header bg-warning">
                                        <h5 class="modal-title">Edit Pelanggan</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">
                                        <div class="mb-2">
                                            <label>Nama</label>
                                            <input type="text" name="name" class="form-control" value="{{ $p->name }}">
                                        </div>

                                        <div class="mb-2">
                                            <label>Email</label>
                                            <input type="email" name="email" class="form-control" value="{{ $p->email }}">
                                        </div>

                                        <div class="mb-2">
                                            <label>No HP</label>
                                            <input type="text" name="phone" class="form-control" value="{{ $p->phone }}">
                                        </div>

                                        <div class="mb-2">
                                            <label>Alamat</label>
                                            <textarea name="alamat" class="form-control">{{ $p->alamat }}</textarea>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button class="btn btn-warning">Update</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    {{-- ================= MODAL HAPUS ================= --}}
                    <div class="modal fade" id="hapusModal{{ $p->id }}" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header bg-danger text-white">
                                    <h5 class="modal-title">Konfirmasi Hapus</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    Yakin ingin menghapus <strong>{{ $p->name }}</strong>?
                                </div>
                                <div class="modal-footer">
                                    <form action="{{ route('pelanggan.destroy',$p->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-danger">Hapus</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection