<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>@yield('title')</title>

    <link rel="icon" type="image/png" href="{{ asset('images/loggo.png') }}">
    <link rel="shortcut icon" href="{{ asset('images/loggo.png') }}">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        html, body {
            margin:0;
            padding:0;
            background:#f4f6f9;
            font-family: 'Segoe UI', sans-serif;
        }

        /* ================= CONTENT ================= */
        .content {
            margin-left:230px;
            min-height:100vh;
        }

        /* ================= NAVBAR ================= */
        .navbar-custom {
            background:#ffffff;
            padding:18px 30px;
            box-shadow:0 4px 20px rgba(0,0,0,0.05);
            border-bottom:1px solid #eee;
            display:flex;
            justify-content:space-between;
            align-items:center;
        }

        .page-wrapper {
            padding:30px;
        }

        .card {
            border-radius:16px;
        }
    </style>
</head>
<body>

@if (!isset($hideSidebar))
    @include('sidebar.admin')
@endif

<div class="{{ isset($hideSidebar) ? '' : 'content' }}">

    @if (!isset($hideSidebar))
    <div class="navbar-custom">
        <div class="fw-semibold fs-5">
            @yield('page')
        </div>

        <div>
            <span class="text-muted small">Admin Aktif</span>
            <span class="fw-semibold ms-2">
                <i class="bi bi-person-circle me-1"></i>
                {{ auth()->user()->name ?? 'Admin' }}
            </span>
        </div>
    </div>
    @endif

    <div class="page-wrapper">
        @yield('content')
    </div>

</div>

<!-- ================= MODAL LOGOUT ================= -->
<div class="modal fade" id="logoutModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content text-center" style="border-radius:14px;">

            <div class="modal-header justify-content-center border-0">
                <h5 class="modal-title fw-bold">
                    <i class="bi bi-exclamation-triangle text-danger me-2"></i>
                    Konfirmasi Logout
                </h5>
            </div>

            <div class="modal-body">
                <p>Apakah anda yakin ingin logout?</p>
            </div>

            <div class="modal-footer justify-content-center border-0">
                <button type="button" class="btn btn-secondary px-4" data-bs-dismiss="modal">
                    Tidak
                </button>

                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="btn btn-danger px-4">
                        Ya
                    </button>
                </form>
            </div>

        </div>
    </div>
</div>

<!-- ================= SCRIPTS ================= -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

@stack('scripts')

</body>
</html>