@extends('layouts.app')

@section('title','Register CRM')

@php
    $hideSidebar = true;
@endphp

@section('content')

<style>

    body {
        background: linear-gradient(135deg, #B22222, #8B0000);
        font-family: 'Segoe UI', sans-serif;
        margin: 0;
    }

    /* Wrapper supaya card benar-benar di tengah */
    .register-wrapper {
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 40px 0; /* ini bikin atas bawah tidak mentok */
    }

    .register-card {
        max-width: 520px;
        width: 95%;
        background-color: #f5f5f5;
        border-radius: 22px;
        padding: 35px 35px; /* padding lebih pendek */
        box-shadow: 0 20px 50px rgba(0,0,0,0.35);
        box-sizing: border-box;
    }

    .register-header {
        text-align: center;
        margin-bottom: 25px;
    }

    .register-header img.logo { 
        max-width: 80px; 
        margin-bottom: 10px; 
        border-radius: 12px; 
    }

    .register-header h4 { 
        color: #0d6efd; 
        font-weight: 700; 
        margin-bottom: 5px; 
    }

    .register-header p { 
        color: #555; 
        font-size: 14px;
    }

    label {
        font-weight: 600;
        color: #d2691e;
        margin-bottom: 5px;
        font-size: 14px;
    }

    input[type="text"], 
    input[type="email"], 
    input[type="password"] {
        border-radius: 12px;
        border: 2px solid #d2691e;
        padding: 10px 12px;
        width: 100%;
        margin-bottom: 15px;
        background-color: #fff8f0;
        font-size: 14px;
    }

    .btn-register {
        width: 100%;
        background-color: #0d6efd;
        color: #fff;
        border-radius: 50px;
        padding: 10px;
        border: none;
        font-size: 14px;
        font-weight: 600;
    }

    .login-link {
        display: block;
        text-align: center;
        margin-top: 12px;
        color:#d2691e; 
        text-decoration: none;
        font-size: 14px;
    }

    .login-link:hover {
        text-decoration: underline;
    }

</style>

<div class="register-wrapper">
    <div class="register-card">

        <div class="register-header">
            <img src="{{ asset('images/loggo.png') }}" alt="Logo Toko" class="logo">
            <h4>REGISTER CRM</h4>
            <p>Toko Bangunan Tamim Malsaly</p>
        </div>

        <form method="POST" action="{{ route('register') }}">
            @csrf

            <label for="name">Name</label>
            <input id="name" type="text" name="name" 
                   value="{{ old('name') }}" required autofocus>

            <label for="email">Email</label>
            <input id="email" type="email" name="email" 
                   value="{{ old('email') }}" required>

            <label for="password">Password</label>
            <input id="password" type="password" 
                   name="password" required>

            <label for="password_confirmation">Confirm Password</label>
            <input id="password_confirmation" type="password" 
                   name="password_confirmation" required>

            <button type="submit" class="btn-register">
                Register
            </button>

            <a class="login-link" href="{{ route('login') }}">
                Already registered? Login
            </a>

        </form>

    </div>
</div>

@endsection