<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login CRM</title>
    <link rel="icon" type="image/png" href="{{ asset('images/loggo.png') }}">
    
    <style>
        body {
            background-color: #001233; /* navy gelap */
            font-family: 'Segoe UI', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
        }

        .login-card {
            max-width: 450px;
            width: 100%;
            background-color: #f5f5f5; /* putih keruh */
            border-radius: 20px;
            padding: 35px 25px;
            text-align: center;
            box-shadow: 0 20px 50px rgba(0,0,0,0.3);
            box-sizing: border-box;
        }

        .login-card img.logo { 
            max-width: 100px; 
            margin-bottom: 20px; 
            border-radius: 12px; 
        }

        .login-card h4 { 
            color: #0d6efd; 
            font-weight: 700; 
            margin-bottom: 10px; 
        }

        .login-card p { 
            color: #333; 
            margin-bottom: 25px; 
        }

        .btn-login {
            background-color: #0d6efd;
            color: #fff;
            border-radius: 50px;
            padding: 12px 35px;
            border: none;
            transition: all 0.2s ease-in-out;
        }
        .btn-login:hover { background-color: #3d8bfd; }
        .btn-login:active { background-color: #6ea8fe; transform: scale(0.97); }

        /* Input dan label oren bata */
        input[type="email"], input[type="password"] {
            border-radius: 12px;
            border: 2px solid #d2691e;
            padding: 12px 14px;
            width: 100%;
            margin-top:5px;
            margin-bottom:10px;
            box-sizing:border-box;
            background-color: #fff8f0; /* putih keruh sedikit terang */
            color: #333;
        }

        label {
            display: block;
            font-weight: 500;
            color: #d2691e;
            margin-bottom: 5px;
        }

        input[type="checkbox"] {
            accent-color: #d2691e;
            width: 18px;
            height: 18px;
            margin-right: 8px;
        }

        .checkbox-label {
            color: #d2691e;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            margin-top: 10px;
        }

        /* responsive */
        @media (max-width:480px){
            .login-card { padding: 25px 15px; }
            .login-card img.logo { max-width: 80px; }
            .btn-login { padding: 10px 25px; font-size: 14px; }
        }
    </style>
</head>
<body>
    <div class="login-card">
        <img src="{{ asset('images/loggo.png') }}" alt="Logo Toko" class="logo">
        <h4>SELAMAT BERGABUNG</h4>
        <p>di Website Tamim Malsaly</p>
        <form method="POST" action="{{ route('login') }}">
            @csrf
            <div>
                <label for="email">Email</label>
                <input id="email" type="email" name="email" required autofocus>
            </div>
            <div>
                <label for="password">Password</label>
                <input id="password" type="password" name="password" required>
            </div>
            <div class="checkbox-label">
                <input type="checkbox" name="remember" id="remember_me">
                <label for="remember_me">Remember me</label>
            </div>
            <div class="mt-4">
                <button type="submit" class="btn-login">Log in</button>
            </div>
        </form>
    </div>
</body>
</html>