@extends('layouts.app')
@section('title','Data Admin')
@section('page','Data Admin')

@section('content')

<div class="card shadow-sm border-0">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0 fw-semibold">Data Admin</h5>

        <!-- BUTTON TAMBAH -->
        <button class="btn btn-primary btn-sm"
                data-bs-toggle="modal"
                data-bs-target="#modalTambah"
                data-bs-toggle="tooltip"
                title="Tambah Admin">
            <i class="bi bi-plus-circle"></i>
        </button>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-light text-center">
                    <tr>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>No. Telp</th>
                        <th>Alamat</th>
                        <th>Jam Masuk</th>
                        <th>Jam Keluar</th>
                        <th width="140">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($admin as $a)
                    <tr>
                        <td>{{ $a->name }}</td>
                        <td>{{ $a->email }}</td>
                        <td>{{ $a->phone }}</td>
                        <td>{{ $a->alamat }}</td>
                        <td>{{ $a->jam_masuk ?? '-' }}</td>
                        <td>{{ $a->jam_keluar ?? '-' }}</td>
                        <td class="text-center">

                            <!-- DETAIL -->
                            <button class="btn btn-info btn-sm text-white"
                                data-bs-toggle="modal"
                                data-bs-target="#modalDetail{{ $a->id }}"
                                title="Detail">
                                <i class="bi bi-eye-fill"></i>
                            </button>

                            <!-- EDIT -->
                            <button class="btn btn-warning btn-sm text-white"
                                data-bs-toggle="modal"
                                data-bs-target="#modalEdit{{ $a->id }}"
                                title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </button>

                            <!-- HAPUS -->
                            <button class="btn btn-danger btn-sm"
                                data-bs-toggle="modal"
                                data-bs-target="#modalHapus{{ $a->id }}"
                                title="Hapus">
                                <i class="bi bi-trash-fill"></i>
                            </button>

                        </td>
                    </tr>

                    <!-- ================= DETAIL MODAL ================= -->
                    <div class="modal fade" id="modalDetail{{ $a->id }}" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Detail Admin</h5>
                                    <button class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <p><strong>Nama:</strong> {{ $a->name }}</p>
                                    <p><strong>Email:</strong> {{ $a->email }}</p>
                                    <p><strong>No. Telp:</strong> {{ $a->phone }}</p>
                                    <p><strong>Alamat:</strong> {{ $a->alamat }}</p>
                                    <p><strong>Jam Masuk:</strong> {{ $a->jam_masuk }}</p>
                                    <p><strong>Jam Keluar:</strong> {{ $a->jam_keluar }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ================= EDIT MODAL ================= -->
                    <div class="modal fade" id="modalEdit{{ $a->id }}" tabindex="-1">
                        <div class="modal-dialog">
                            <form action="{{ route('admin.update',$a->id) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Edit Admin</h5>
                                        <button class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body">
                                        <input type="text" name="name" value="{{ $a->name }}" class="form-control mb-2" placeholder="Nama">
                                        <input type="email" name="email" value="{{ $a->email }}" class="form-control mb-2" placeholder="Email">
                                        <input type="text" name="phone" value="{{ $a->phone }}" class="form-control mb-2" placeholder="No. Telp">
                                        <input type="text" name="alamat" value="{{ $a->alamat }}" class="form-control mb-2" placeholder="Alamat">
                                        <input type="time" name="jam_masuk" value="{{ $a->jam_masuk }}" class="form-control mb-2">
                                        <input type="time" name="jam_keluar" value="{{ $a->jam_keluar }}" class="form-control">
                                    </div>

                                    <div class="modal-footer">
                                        <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                        <button class="btn btn-warning">Update</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- ================= HAPUS MODAL ================= -->
                    <div class="modal fade" id="modalHapus{{ $a->id }}" tabindex="-1">
                        <div class="modal-dialog modal-sm">
                            <form action="{{ route('admin.destroy',$a->id) }}" method="POST">
                                @csrf
                                @method('DELETE')

                                <div class="modal-content">
                                    <div class="modal-body text-center">
                                        <p>Yakin ingin menghapus?</p>
                                        <button class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Batal</button>
                                        <button class="btn btn-danger btn-sm">Hapus</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- ================= TAMBAH MODAL ================= -->
<div class="modal fade" id="modalTambah" tabindex="-1">
    <div class="modal-dialog">
        <form action="{{ route('admin.store') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Admin</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="text" name="name" class="form-control mb-2" placeholder="Nama" required>
                    <input type="email" name="email" class="form-control mb-2" placeholder="Email" required>
                    <input type="text" name="phone" class="form-control mb-2" placeholder="No. Telp" required>
                    <input type="text" name="alamat" class="form-control" placeholder="Alamat" required>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button class="btn btn-primary">Simpan</button>
                </div>
            </div>
        </form>
    </div>
</div>

@endsection