<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('transaksis', function (Blueprint $table) {

            $table->unsignedBigInteger('admin_id')->nullable()->after('pelanggan_id');
            $table->string('alamat')->nullable()->after('total');
            $table->integer('diskon')->nullable()->after('alamat');

            $table->foreign('admin_id')
                ->references('id')
                ->on('users')
                ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('transaksis', function (Blueprint $table) {
            $table->dropForeign(['admin_id']);
            $table->dropColumn(['admin_id','alamat','diskon']);
        });
    }
};
