<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('transaksis', function (Blueprint $table) {
            $table->date('tanggal')->after('id');
            $table->unsignedBigInteger('barang_id')->after('tanggal');
            $table->string('nama_barang')->after('barang_id');
            $table->string('kategori')->after('nama_barang');
            $table->integer('jumlah')->after('kategori');
            $table->integer('harga')->after('jumlah');
            $table->integer('total')->after('harga');
            $table->enum('metode_pembayaran', ['tempo','tunai','transfer'])->after('total');

            $table->foreign('barang_id')->references('id')->on('barangs')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('transaksis', function (Blueprint $table) {
            $table->dropForeign(['barang_id']);
            $table->dropColumn([
                'tanggal','barang_id','nama_barang','kategori','jumlah','harga','total','metode_pembayaran'
            ]);
        });
    }
};