<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('barangs', function (Blueprint $table) {
            $table->string('nama')->after('id');
            $table->string('kategori')->after('nama');
            $table->string('merk')->after('kategori');
            $table->string('ukuran_spesifikasi')->after('merk');
            $table->string('satuan')->after('ukuran_spesifikasi');
            $table->integer('harga')->after('satuan');
            $table->integer('stok')->after('harga');
        });
    }

    public function down(): void
    {
        Schema::table('barangs', function (Blueprint $table) {
            $table->dropColumn([
                'nama','kategori','merk','ukuran_spesifikasi','satuan','harga','stok'
            ]);
        });
    }
};