<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('transaksis', function (Blueprint $table) {
            $table->id(); // id transaksi
            $table->date('tanggal'); // tanggal transaksi
            $table->unsignedBigInteger('barang_id'); // relasi ke barang
            $table->string('nama_barang'); 
            $table->string('kategori'); 
            $table->integer('jumlah'); 
            $table->integer('harga'); 
            $table->integer('total'); 
            $table->enum('metode_pembayaran', ['tempo','tunai','transfer']); 
            $table->timestamps();

            $table->foreign('barang_id')->references('id')->on('barangs')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('transaksis');
    }
};