<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaksi extends Model
{
    protected $table = 'transaksis';

    protected $fillable = [
        'pelanggan_id',
        'admin_id',
        'tanggal',
        'barang_id',
        'nama_barang',
        'kategori',
        'jumlah',
        'harga',
        'total',
        'diskon',
        'alamat',
        'metode_pembayaran'
    ];

    public function pelanggan()
    {
        return $this->belongsTo(User::class, 'pelanggan_id');
    }

    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }
}