<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Transaksi;
use App\Models\User;

class TransaksiController extends Controller
{
    // TAMPIL DATA
    public function index()
    {
        $transaksi = Transaksi::with(['pelanggan','admin'])->get();
        return view('transaksi.index', compact('transaksi'));
    }

    // SIMPAN DATA (ADMIN & ALAMAT OTOMATIS)
    public function store(Request $request)
    {
        $request->validate([
            'pelanggan_id' => 'required',
            'nama_barang'  => 'required',
            'jumlah'       => 'required|numeric',
            'harga'        => 'required|numeric',
        ]);

        // Ambil data pelanggan
        $pelanggan = User::findOrFail($request->pelanggan_id);

        // Hitung subtotal
        $subtotal = $request->jumlah * $request->harga;

        // Hitung diskon
        $diskonPersen = $request->diskon ?? 0;
        $potongan = ($subtotal * $diskonPersen) / 100;
        $totalAkhir = $subtotal - $potongan;

        Transaksi::create([
            'pelanggan_id' => $request->pelanggan_id,
            'admin_id'     => Auth::id(), // 🔥 otomatis admin login
            'tanggal'      => now(),
            'barang_id'    => $request->barang_id,
            'nama_barang'  => $request->nama_barang,
            'kategori'     => $request->kategori,
            'jumlah'       => $request->jumlah,
            'harga'        => $request->harga,
            'total'        => $totalAkhir,
            'diskon'       => $diskonPersen,
            'alamat'       => $pelanggan->alamat, // 🔥 otomatis ambil alamat pelanggan
            'metode_pembayaran' => $request->metode_pembayaran,
        ]);

        return redirect()->route('transaksi.index')
            ->with('success','Transaksi berhasil disimpan');
    }

    // HAPUS
    public function destroy($id)
    {
        $data = Transaksi::findOrFail($id);
        $data->delete();

        return redirect()->route('transaksi.index')
            ->with('success','Transaksi berhasil dihapus');
    }
}