<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;

class PelangganController extends Controller
{
    public function index()
    {
        $pelanggan = User::where('role','pelanggan')
            ->with('transaksis')
            ->get();

        return view('pelanggan.index', compact('pelanggan'));
    }

    public function destroy($id)
    {
        $pelanggan = User::findOrFail($id);
        $pelanggan->delete();

        return redirect()->route('pelanggan.index')
            ->with('success','Data pelanggan berhasil dihapus');
    }

    public function update(Request $request, $id)
    {
        $pelanggan = User::findOrFail($id);

        $pelanggan->update([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'alamat' => $request->alamat,
        ]);

        return redirect()->route('pelanggan.index')
            ->with('success','Data berhasil diupdate');
    }
}