<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Barang;
use App\Models\Transaksi;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        // ===== Total Counts =====
        $totalAdmin = User::where('role','admin')->count();
        $totalBarang = Barang::count();
        $totalPelanggan = User::where('role','pelanggan')->count();
        $totalTransaksi = Transaksi::count();

        // ===== Barang yang sering dibeli Pelanggan A =====
        $frequentItemsPelangganA = Transaksi::select(
                'barangs.nama as nama_barang', 
                DB::raw('count(*) as jumlah')
            )
            ->join('barangs','transaksis.barang_id','=','barangs.id')
            ->where('transaksis.pelanggan_id', 1)
            ->groupBy('barangs.nama')
            ->orderByDesc('jumlah')
            ->get();

        // ===== Barang paling banyak dibeli per alamat =====
        $popularItemsByLocation = Transaksi::select(
                'users.alamat as nama_alamat', 
                'barangs.nama as nama_barang', 
                DB::raw('count(*) as jumlah')
            )
            ->join('users','transaksis.pelanggan_id','=','users.id')
            ->join('barangs','transaksis.barang_id','=','barangs.id')
            ->groupBy('users.alamat','barangs.nama')
            ->orderByDesc('jumlah')
            ->get();

        // ===== Rekomendasi promo/hadiah untuk pelanggan loyal =====
        $promoRecommendations = Transaksi::select(
                'users.name as nama_pelanggan', 
                DB::raw('count(*) as total_beli')
            )
            ->join('users','transaksis.pelanggan_id','=','users.id')
            ->groupBy('users.id','users.name')
            ->orderByDesc('total_beli')
            ->limit(5)
            ->get()
            ->map(function($p){
                $p->promo = 'Diskon 10% / Hadiah Spesial';
                return $p;
            });

        return view('dashboard', compact(
            'totalAdmin',
            'totalBarang',
            'totalPelanggan',
            'totalTransaksi',
            'frequentItemsPelangganA',
            'popularItemsByLocation',
            'promoRecommendations'
        ));
    }
}